/*
 * Decompiled with CFR 0.152.
 */
package net.famkruithof.logagent;

import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.famkruithof.logagent.LogConfigurator;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.IFEQ;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NOP;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.Type;
import org.apache.bcel.util.ByteSequence;

class LogTransformer
implements ClassFileTransformer {
    private static final String LOGGER = "__net_famkruithof_logagent_log_";
    private static final String CLASS = LogTransformer.class.getName();
    private LogConfigurator config;
    private static Logger log = Logger.getLogger(CLASS);

    LogTransformer(LogConfigurator conf, Instrumentation inst) {
        this.config = conf;
    }

    public byte[] transform(ClassLoader loader, String className, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (!this.config.isApplicable(className)) {
            log.logp(Level.FINE, CLASS, "transform", "Not instrumenting: {0} ClassLoader {1}.", new Object[]{className, loader});
            return null;
        }
        log.logp(Level.FINE, CLASS, "transform", "Instrumenting: {0} ClassLoader {1}.", new Object[]{className, loader});
        try {
            JavaClass cls = new ClassParser((InputStream)new ByteSequence(classfileBuffer), className).parse();
            ClassGen cg = new ClassGen(cls);
            ConstantPoolGen cp = cg.getConstantPool();
            InstructionFactory f = new InstructionFactory(cg, cp);
            Method[] methods = cg.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                this.insertTrace(methods[i], cg, cp, f);
            }
            this.injectLogger(cg, cp, f);
            return cg.getJavaClass().getBytes();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private synchronized void injectLogger(ClassGen cg, ConstantPoolGen cp, InstructionFactory f) {
        InstructionList il;
        MethodGen mg;
        String name = cg.getClassName();
        FieldGen field = new FieldGen(26, (Type)new ObjectType("java.util.logging.Logger"), LOGGER, cp);
        cg.addField(field.getField());
        Method[] methods = cg.getMethods();
        int i = -1;
        boolean found = false;
        while (i < methods.length - 1 && !found) {
            found = methods[++i].getName().equals("<clinit>");
        }
        if (found) {
            mg = new MethodGen(methods[i], name, cp);
            cg.removeMethod(methods[i]);
        } else {
            il = new InstructionList();
            mg = new MethodGen(8, (Type)Type.VOID, Type.NO_ARGS, new String[0], "<clinit>", name, il, cp);
            il.append((Instruction)InstructionFactory.createReturn((Type)Type.VOID));
        }
        il = new InstructionList();
        il.append((CompoundInstruction)new PUSH(cp, "logagent." + name));
        il.append((Instruction)f.createInvoke("java.util.logging.Logger", "getLogger", (Type)new ObjectType("java.util.logging.Logger"), new Type[]{Type.STRING}, (short)184));
        il.append((Instruction)f.createFieldAccess(name, LOGGER, (Type)new ObjectType("java.util.logging.Logger"), (short)179));
        this.addMethod(cg, mg, il);
    }

    private void insertTrace(Method method, ClassGen cg, ConstantPoolGen cp, InstructionFactory f) {
        String className = cg.getClassName();
        String methodNameLong = method.toString();
        String methodName = method.getName();
        if (method.isNative() || method.isAbstract() || method.getCode() == null || !this.config.isApplicable(className, methodName)) {
            log.logp(Level.FINEST, CLASS, "insertTrace", "Not inserting traceing for:  {0}::{1}.", new Object[]{className, methodNameLong});
            return;
        }
        log.logp(Level.FINEST, CLASS, "insertTrace", "Inserting traceing for:  {0}::{1}.", new Object[]{className, methodNameLong});
        MethodGen mg = new MethodGen(method, className, cp);
        InstructionList enteringIl = new InstructionList();
        this.insertEntering(enteringIl, cp, f, className, methodName, mg);
        this.addDoubleExecProtection(enteringIl, cp, f, className, methodName, mg);
        cg.removeMethod(method);
        this.addMethod(cg, mg, enteringIl);
    }

    private void addDoubleExecProtection(InstructionList il, ConstantPoolGen cp, InstructionFactory f, String className, String methodName, MethodGen mg) {
        LocalVariableGen var = mg.addLocalVariable("e", (Type)Type.OBJECT, il.getEnd(), il.getEnd());
        BranchInstruction toLog1 = InstructionFactory.createBranchInstruction((short)167, null);
        BranchHandle toLogInsert = il.append(toLog1);
        InstructionHandle throwLog = il.append((Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)var.getIndex()));
        il.append((Instruction)f.createInvoke("net.famkruithof.logagent.LogProtector", "stopTrace", (Type)Type.VOID, Type.NO_ARGS, (short)184));
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)var.getIndex()));
        il.append(InstructionConstants.ATHROW);
        InstructionHandle catchHandle = il.append((Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)var.getIndex()));
        InstructionHandle logHandle = il.append((Instruction)f.createInvoke("net.famkruithof.logagent.LogProtector", "stopTrace", (Type)Type.VOID, Type.NO_ARGS, (short)184));
        InstructionHandle endHandle = il.append((Instruction)new NOP());
        toLog1.setTarget(logHandle);
        BranchHandle begin = il.insert((BranchInstruction)new IFEQ(endHandle));
        begin = begin.getNext();
        il.insert((Instruction)f.createInvoke("net.famkruithof.logagent.LogProtector", "startTrace", (Type)Type.BOOLEAN, Type.NO_ARGS, (short)184));
        mg.addExceptionHandler((InstructionHandle)begin, (InstructionHandle)toLogInsert, catchHandle, new ObjectType("java.lang.Exception"));
        mg.addExceptionHandler((InstructionHandle)begin, (InstructionHandle)toLogInsert, throwLog, null);
    }

    private InstructionList insertEntering(InstructionList il, ConstantPoolGen cp, InstructionFactory f, String className, String methodName, MethodGen mg) {
        il.append((Instruction)f.createFieldAccess(className, LOGGER, (Type)new ObjectType("java.util.logging.Logger"), (short)178));
        il.append((CompoundInstruction)new PUSH(cp, className));
        il.append((CompoundInstruction)new PUSH(cp, methodName));
        this.appendArguments(il, cp, f, mg);
        il.append((Instruction)f.createInvoke("java.util.logging.Logger", "entering", (Type)Type.VOID, new Type[]{Type.STRING, Type.STRING, new ArrayType((Type)Type.OBJECT, 1)}, (short)182));
        return il;
    }

    private void appendArguments(InstructionList il, ConstantPoolGen cp, InstructionFactory f, MethodGen mg) {
        String[] args = mg.getArgumentNames();
        int numArgs = args.length + (mg.isStatic() ? 0 : 1);
        int start = this.isConstructor(mg) ? 1 : 0;
        int numentries = (numArgs -= start) * 2;
        il.append((CompoundInstruction)new PUSH(cp, numentries));
        il.append(f.createNewArray((Type)Type.OBJECT, (short)1));
        LocalVariableGen[] vars = mg.getLocalVariables();
        if (vars.length < numArgs) {
            log.logp(Level.WARNING, CLASS, "appendArguments", "Local Vars " + vars.length + "<" + numArgs + " args. for " + mg);
        }
        int i = start;
        int j = 0;
        while (j < numentries) {
            LocalVariableGen var = vars[i];
            il.append((Instruction)InstructionConstants.DUP);
            il.append((CompoundInstruction)new PUSH(cp, j));
            String hdr = "<" + var.getName() + ">=";
            cp.addString(hdr);
            il.append((CompoundInstruction)new PUSH(cp, hdr));
            il.append((Instruction)InstructionConstants.AASTORE);
            il.append((Instruction)InstructionConstants.DUP);
            il.append((CompoundInstruction)new PUSH(cp, ++j));
            ++j;
            if (var.getType().equals((Object)Type.BOOLEAN)) {
                il.append((Instruction)InstructionFactory.createLoad((Type)Type.BOOLEAN, (int)var.getIndex()));
                il.append((Instruction)f.createInvoke("java.lang.Boolean", "valueOf", (Type)new ObjectType("java.lang.Boolean"), new Type[]{Type.BOOLEAN}, (short)184));
            } else if (var.getType().equals((Object)Type.BYTE)) {
                il.append((Instruction)InstructionFactory.createLoad((Type)Type.BYTE, (int)var.getIndex()));
                il.append((Instruction)f.createInvoke("java.lang.Byte", "valueOf", (Type)new ObjectType("java.lang.Byte"), new Type[]{Type.BYTE}, (short)184));
            } else if (var.getType().equals((Object)Type.CHAR)) {
                il.append((Instruction)InstructionFactory.createLoad((Type)Type.CHAR, (int)var.getIndex()));
                il.append((Instruction)f.createInvoke("java.lang.Character", "valueOf", (Type)new ObjectType("java.lang.Character"), new Type[]{Type.CHAR}, (short)184));
            } else if (var.getType().equals((Object)Type.DOUBLE)) {
                il.append((Instruction)InstructionFactory.createLoad((Type)Type.DOUBLE, (int)var.getIndex()));
                il.append((Instruction)f.createInvoke("java.lang.Double", "valueOf", (Type)new ObjectType("java.lang.Double"), new Type[]{Type.DOUBLE}, (short)184));
            } else if (var.getType().equals((Object)Type.FLOAT)) {
                il.append((Instruction)InstructionFactory.createLoad((Type)Type.FLOAT, (int)var.getIndex()));
                il.append((Instruction)f.createInvoke("java.lang.Float", "valueOf", (Type)new ObjectType("java.lang.Float"), new Type[]{Type.FLOAT}, (short)184));
            } else if (var.getType().equals((Object)Type.INT)) {
                il.append((Instruction)InstructionFactory.createLoad((Type)Type.INT, (int)var.getIndex()));
                il.append((Instruction)f.createInvoke("java.lang.Integer", "valueOf", (Type)new ObjectType("java.lang.Integer"), new Type[]{Type.INT}, (short)184));
            } else if (var.getType().equals((Object)Type.LONG)) {
                il.append((Instruction)InstructionFactory.createLoad((Type)Type.LONG, (int)var.getIndex()));
                il.append((Instruction)f.createInvoke("java.lang.Long", "valueOf", (Type)new ObjectType("java.lang.Long"), new Type[]{Type.LONG}, (short)184));
            } else if (var.getType().equals((Object)Type.SHORT)) {
                il.append((Instruction)InstructionFactory.createLoad((Type)Type.SHORT, (int)var.getIndex()));
                il.append((Instruction)f.createInvoke("java.lang.Short", "valueOf", (Type)new ObjectType("java.lang.Short"), new Type[]{Type.SHORT}, (short)184));
            } else {
                il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)var.getIndex()));
            }
            il.append((Instruction)InstructionConstants.AASTORE);
            ++i;
        }
    }

    private boolean isConstructor(MethodGen mg) {
        return mg.getName().equals("<init>");
    }

    private void addMethod(ClassGen cg, MethodGen mg, InstructionList insert) {
        InstructionList il = mg.getInstructionList();
        il.insert(insert);
        il.setPositions();
        il.update();
        mg.setMaxStack();
        mg.setMaxLocals();
        cg.addMethod(mg.getMethod());
        il.dispose();
    }
}

